(function(){
    function initOne(id){
        var wrap = document.getElementById(id); if(!wrap) return;
        var slider = wrap.querySelector('.gooloo-toplist-slider'); if(!slider) return;
        var prev = wrap.querySelector('.gooloo-toplist-prev');
        var next = wrap.querySelector('.gooloo-toplist-next');
        var items = slider.querySelectorAll('.gooloo-toplist-item'); if(!items.length) return;
        var index = 0;
        function update(){
            var per = window.innerWidth <= 768 ? 1 : 3;
            items.forEach(function(it){ it.style.flex = '0 0 ' + (100/per) + '%'; it.style.maxWidth = (100/per) + '%'; });
            slider.style.transform = 'translateX(' + (-index * (100/per)) + '%)';
        }
        function go(dir){
            var per = window.innerWidth <= 768 ? 1 : 3;
            var max = Math.max(0, items.length - per);
            index = Math.max(0, Math.min(max, index + (dir==='next'? per : -per)));
            update();
        }
        update();
        window.addEventListener('resize', update);
        prev && prev.addEventListener('click', function(){ go('prev'); });
        next && next.addEventListener('click', function(){ go('next'); });
    }
    (window.GOOLOO_TOPLIST||[]).forEach(initOne);
    window.addEventListener('load', function(){ (window.GOOLOO_TOPLIST||[]).forEach(initOne); });
})();
