(function(){
    const { createElement: el } = wp.element;
    const { PluginDocumentSettingPanel } = wp.editPost;
    const { registerPlugin } = wp.plugins;
    const { TextControl, PanelRow, Notice } = wp.components;
    const { __ } = wp.i18n;
    const { select, dispatch } = wp.data;

    const MetaPanel = function(){
        const getMeta = () => select('core/editor').getEditedPostAttribute('meta') || {};
        const setMeta = (key, val) => {
            const m = Object.assign({}, getMeta()); m[key] = val;
            dispatch('core/editor').editPost({ meta: m });
        };
        const meta = getMeta();
        return el(PluginDocumentSettingPanel, { name:'gooloo-reviewbar-panel', title: __('Review Bar', 'gooloo'), className:'gooloo-reviewbar-panel' },
            el(PanelRow, {}, el(TextControl, { label: __('Bewertung (%)','gooloo'), type:'number', step:'0.01', min:0, max:100, value: meta._gooloo_reviewbar_value || '', onChange: (v)=> setMeta('_gooloo_reviewbar_value', v) })),
            el(PanelRow, {}, el(TextControl, { label: __('Preis','gooloo'), type:'number', step:'0.01', min:0, value: meta._gooloo_reviewbar_price || '', onChange: (v)=> setMeta('_gooloo_reviewbar_price', v) })),
            el(PanelRow, {}, el(TextControl, { label: __('Brand','gooloo'), value: meta._gooloo_reviewbar_brand || '', onChange: (v)=> setMeta('_gooloo_reviewbar_brand', v) })),
            el(PanelRow, {}, el(TextControl, { label: __('SKU / EAN / ISBN','gooloo'), value: meta._gooloo_reviewbar_sku || '', onChange: (v)=> setMeta('_gooloo_reviewbar_sku', v) })),
            el(Notice, { status:'info', isDismissible:false }, __('Werte werden beim Speichern automatisch in die Datenbank-Tabelle synchronisiert.','gooloo'))
        );
    };
    registerPlugin('gooloo-reviewbar-meta-panel', { render: MetaPanel });
})();
