<?php
// Add this code to your theme's functions.php file or in a custom plugin

// Schedule the daily cleanup event
function schedule_action_scheduler_cleanup() {
    if (!wp_next_scheduled('daily_action_scheduler_cleanup')) {
        wp_schedule_event(time(), 'daily', 'daily_action_scheduler_cleanup');
    }
}
add_action('wp', 'schedule_action_scheduler_cleanup');

// Function to perform the cleanup
function perform_action_scheduler_cleanup() {
    global $wpdb;

    // Delete completed actions
    $wpdb->query("DELETE FROM {$wpdb->prefix}wpbh_actionscheduler_actions WHERE status = 'complete'");

    // Delete failed actions
    $wpdb->query("DELETE FROM {$wpdb->prefix}wpbh_actionscheduler_actions WHERE status = 'failed'");

    // Clean up associated logs
    $wpdb->query("DELETE FROM {$wpdb->prefix}wpbh_actionscheduler_logs WHERE action_id NOT IN (SELECT action_id FROM {$wpdb->prefix}wpbh_actionscheduler_actions)");
}
add_action('daily_action_scheduler_cleanup', 'perform_action_scheduler_cleanup');

// Cleanup function when the plugin is deactivated
function cleanup_scheduler_on_deactivation() {
    wp_clear_scheduled_hook('daily_action_scheduler_cleanup');
}
register_deactivation_hook(__FILE__, 'cleanup_scheduler_on_deactivation');